using System;
using System.Data;
using BLOODUNITTEST = gov.va.med.vbecs.Common.VbecsTables.BloodUnitTest;

namespace gov.va.med.vbecs.BOL
{
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike Smith</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/4/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>BloodTestBase</summary>

		#endregion

	public class BloodTestBase : BaseBusinessObject
	{
		#region Variables

		private System.Guid _bloodUnitTestGuid;
		private BloodTestType _bloodTestType;
		private string _testComments, _testResultId;
		private System.DateTime _testDate;
		
		#endregion

		#region Constructors
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///<Case type="0" testid ="1812"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid BloodTestBase object</ExpectedOutput>
		///	</Case>
		///<Case type="1" testid ="604"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///	<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public BloodTestBase()
		{
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2394"> 
		///		<ExpectedInput>DataRow containing BloodTestBase data</ExpectedInput>
		///		<ExpectedOutput>BloodTestBase object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="605"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates BloodTestBase object and populates it with data from DataRow
		/// </summary>
		public BloodTestBase(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}
		#endregion

		#region Properties	

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="868"> 
		///		<ExpectedInput>Valid GUID</ExpectedInput>
		///		<ExpectedOutput>Valid GUID</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="606"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Gets and sets the BloodUnitTestGuid
		///</summary>
		public System.Guid BloodUnitTestGuid
		{
			get
			{
				return this._bloodUnitTestGuid;
			}
			set
			{
				this._bloodUnitTestGuid = value;
			}
		}
		
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="869"> 
		///		<ExpectedInput>Valid BloodTestType object</ExpectedInput>
		///		<ExpectedOutput>Valid BloodTestType</ExpectedOutput>
		///	</Case>
		///	
		///	<Case type="1" testid ="1813"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Gets and sets the blood test type.
		///</summary>
		public BloodTestType BloodTestTypeObj
		{
			get
			{
				return this._bloodTestType;
			}
			set
			{
				this._bloodTestType = value;
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="870"> 
		///		<ExpectedInput>Valid date</ExpectedInput>
		///		<ExpectedOutput>Valid date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="607"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Gets and sets the date the blood was tested.
		///</summary>
		public System.DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="871"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>test result Id</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1814"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Gets and sets the result of the blood test.
		///</summary>
		public string TestResultId
		{
			get
			{
				return this._testResultId;
			}
			set
			{
				this._testResultId = value;
			}
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="872"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1815"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Gets and sets the blood test comments.
		///</summary>
		public string TestComments
		{
			get
			{
				return this._testComments;
			}
			set
			{
				this._testComments = value;
			}
		}

		
		#endregion

		#region Methods
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="1437"> 
		///		<ExpectedInput>data row</ExpectedInput>
		///		<ExpectedOutput>data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="608"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update>Unused</Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.BloodUnitTestGuid))
			{
				dtRow[BLOODUNITTEST.BloodUnitTestGuid] = this.BloodUnitTestGuid;
			}
			if(dtRow.Table.Columns.Contains(Common.VbecsTables.BloodTestType.BloodTestTypeId))
			{
				dtRow[Common.VbecsTables.BloodTestType.BloodTestTypeId] = this.BloodTestTypeObj.BloodTestTypeId;
			}
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestComments))
			{
				dtRow[BLOODUNITTEST.TestComments] = this.TestComments;
			}
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestDate))
			{
				dtRow[BLOODUNITTEST.TestDate] = this.TestDate;
			}
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestResultId))
			{
				dtRow[BLOODUNITTEST.TestResultId] = this.TestResultId;
			}
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.DivisionCode))
			{
				dtRow[BLOODUNITTEST.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			}
			return dtRow;
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.BloodUnitTestGuid))
			{
				if (dtRow.IsNull(BLOODUNITTEST.BloodUnitTestGuid))
					this.BloodUnitTestGuid = System.Guid.Empty; 
				else
					this.BloodUnitTestGuid = (System.Guid) dtRow[BLOODUNITTEST.BloodUnitTestGuid];
			}

			if(dtRow.Table.Columns.Contains(Common.VbecsTables.BloodTestType.BloodTestTypeId))
			{
				int bloodTestTypeId = 0;

				if (!dtRow.IsNull(Common.VbecsTables.BloodTestType.BloodTestTypeId))
				{
					bloodTestTypeId = (int) dtRow[Common.VbecsTables.BloodTestType.BloodTestTypeId];
				}			
				
				this.BloodTestTypeObj = new BOL.BloodTestType(bloodTestTypeId);
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestComments))
			{
				if (dtRow.IsNull(BLOODUNITTEST.TestComments))
					this.TestComments = string.Empty;
				else
					this.TestComments = dtRow[BLOODUNITTEST.TestComments].ToString();				
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestDate))
			{
				if (dtRow.IsNull(BLOODUNITTEST.TestDate))
					this.TestDate = System.DateTime.MinValue;
				else
					this.TestDate = (System.DateTime)dtRow[BLOODUNITTEST.TestDate];				
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITTEST.TestResultId))
			{
				if (dtRow.IsNull(BLOODUNITTEST.TestResultId))
					this.TestResultId = string.Empty;
				else
					this.TestResultId = dtRow[BLOODUNITTEST.TestResultId].ToString();
			}
		}



		#endregion
	}
}


